@extends('layouts.app')

@section('title', 'SAM Bans - Error')

@section('content')
<div class="sam-bans-container">
    <div class="sam-error-container">
        <div class="sam-error-card">
            <div class="sam-error-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            
            <div class="sam-error-content">
                <h1 class="sam-error-title">Connection Error</h1>
                <p class="sam-error-message">{{ $error }}</p>
                
                @if($details && config('app.debug'))
                    <div class="sam-error-details">
                        <h3>Technical Details:</h3>
                        <code class="sam-error-code">{{ $details }}</code>
                    </div>
                @endif

                <div class="sam-error-suggestions">
                    <h3>Possible Solutions:</h3>
                    <ul>
                        <li>Check that the SAM database is running and accessible</li>
                        <li>Verify the database connection settings in the plugin configuration</li>
                        <li>Ensure the database user has proper permissions</li>
                        <li>Check that the SAM tables exist in the database</li>
                    </ul>
                </div>

                <div class="sam-error-actions">
                    <a href="{{ route('sambans.index') }}" class="sam-btn sam-btn-primary">
                        <i class="fas fa-refresh"></i>
                        Try Again
                    </a>
                    
                    <a href="{{ url('/') }}" class="sam-btn sam-btn-secondary">
                        <i class="fas fa-home"></i>
                        Go Home
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.sam-error-container {
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 60vh;
    padding: var(--spacing-xl);
}

.sam-error-card {
    background: var(--dark-gray-lighter);
    border-radius: var(--border-radius-lg);
    border: 1px solid var(--dark-gray-lightest);
    box-shadow: var(--box-shadow-lg);
    padding: var(--spacing-xxl);
    text-align: center;
    max-width: 600px;
    width: 100%;
}

.sam-error-icon {
    font-size: 4rem;
    color: var(--danger);
    margin-bottom: var(--spacing-lg);
}

.sam-error-content {
    .sam-error-title {
        font-size: 2rem;
        font-weight: 700;
        color: var(--white);
        margin-bottom: var(--spacing-md);
    }

    .sam-error-message {
        font-size: 1.1rem;
        color: var(--lighter-gray);
        margin-bottom: var(--spacing-lg);
        line-height: 1.5;
    }

    .sam-error-details {
        background: var(--dark-gray-lightest);
        border-radius: var(--border-radius-md);
        padding: var(--spacing-lg);
        margin-bottom: var(--spacing-lg);
        text-align: left;

        h3 {
            color: var(--warning);
            margin-bottom: var(--spacing-sm);
            font-size: 1rem;
        }

        .sam-error-code {
            background: var(--black);
            color: var(--danger);
            padding: var(--spacing-md);
            border-radius: var(--border-radius-sm);
            font-family: 'Courier New', monospace;
            font-size: 0.9rem;
            display: block;
            white-space: pre-wrap;
            word-break: break-word;
        }
    }

    .sam-error-suggestions {
        background: var(--dark-gray-lightest);
        border-radius: var(--border-radius-md);
        padding: var(--spacing-lg);
        margin-bottom: var(--spacing-lg);
        text-align: left;

        h3 {
            color: var(--info);
            margin-bottom: var(--spacing-md);
            font-size: 1rem;
        }

        ul {
            list-style: none;
            padding: 0;
            margin: 0;

            li {
                color: var(--lighter-gray);
                margin-bottom: var(--spacing-sm);
                padding-left: var(--spacing-lg);
                position: relative;
                line-height: 1.4;

                &:before {
                    content: '•';
                    color: var(--primary-color);
                    font-weight: bold;
                    position: absolute;
                    left: 0;
                }

                &:last-child {
                    margin-bottom: 0;
                }
            }
        }
    }

    .sam-error-actions {
        display: flex;
        gap: var(--spacing-md);
        justify-content: center;
        flex-wrap: wrap;
    }
}

@media (max-width: var(--breakpoint-sm)) {
    .sam-error-container {
        padding: var(--spacing-md);
    }

    .sam-error-card {
        padding: var(--spacing-lg);
    }

    .sam-error-icon {
        font-size: 3rem;
    }

    .sam-error-title {
        font-size: 1.5rem !important;
    }

    .sam-error-actions {
        flex-direction: column;
    }
}
</style>
@endsection